# Custom Login #

[![WordPress plugin](https://img.shields.io/wordpress/plugin/dt/custom-login.svg?style=flat)](https://wordpress.org/plugins/custom-login/) 
[![WordPress plugin](https://img.shields.io/wordpress/plugin/v/custom-login.svg?style=flat)](https://wordpress.org/plugins/custom-login/) 
[![WordPress](https://img.shields.io/wordpress/v/custom-login.svg?style=flat)]() 
[![License](https://img.shields.io/badge/license-GPL--2.0%2B-red.svg)](https://github.com/thefrosty/custom-login/blob/master/license.txt)

**Contributors:** [austyfrosty](https://profiles.wordpress.org/austyfrosty), [frostymedia](https://profiles.wordpress.org/frostymedia)  
**Donate link:** [PayPal](https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=7431290)  
**Tags:** admin, branding, customization, custom login, login, logo, error, login error, custom login pro  
**Requires at least:** 4.9  
**Tested up to:** 5.2  
**Stable tag:** trunk  
**License:** GPLv2 or later  
**License URI:** http://www.gnu.org/licenses/gpl-2.0.html  

Custom Login allows you to easily customize your admin login page, works great for client sites!

## Description ##

Custom Login 2.0 was 140% faster than version 1.0, and version 3.0 is now even better! *Minimum WordPress version is 4.9*

For more information visit the official [Custom Login](https://frosty.media/plugins/custom-login/) page.

> <strong>Support</strong><br>
> [Austin](http://austin.passy.co) and the [Frosty Media](https://frosty.media/) team will always try our best to support the Custom Login plugin on the WordPress.org forum, but please note that we can not guarantee a response in a timely manner. If you have an issue we would appriciate you using GitHub or purchasing priority support on our site.
>
> Any extensions purchased on [Frosty Media](https://frosty.media/) (not hosted on WordPress.org) will not be supported on the WordPress.org forum. You can always browse our *small* but growing [documentation](https://frosty.media/docs) for further assistance. You need a valid license key to make support submissions *on our site*. We thank you in advance. 

> <strong>Bug Reports</strong><br>
> Bug reports for Custom Login are [welcomed on GitHub](https://github.com/thefrosty/custom-login). 

### Video ###

[![IMAGE ALT TEXT HERE](https://img.youtube.com/vi/hZkc-t36xYQ/0.jpg)](https://www.youtube.com/watch?v=hZkc-t36xYQ)

### Extensions ###

There are currently 7 premium extensions available, with more coming (suggestions welcome - and *will be offered for free to said user*).

**Extensions available now**

* [Stealth Login](https://frosty.media/plugins/custom-login-stealth-login/?utm_source=wordpressorg&utm_medium=custom-login&utm_campaign=readme.txt "Custom Login Stealth Login") - obscure your login URL.
* [Page Template](https://frosty.media/plugins/custom-login-page-template/?utm_source=wordpressorg&utm_medium=custom-login&utm_campaign=readme.txt "Custom Login Page Template") - add a login form to any WordPress page.
* [Login Redirects](https://frosty.media/plugins/custom-login-redirects/?utm_source=wordpressorg&utm_medium=custom-login&utm_campaign=readme.txt "Custom Login Redirects") - Manage login redirects.
* [No Password](https://frosty.media/plugins/custom-login-no-password-login/?utm_source=wordpressorg&utm_medium=custom-login&utm_campaign=readme.txt "Custom Login No Password logins") - allow users to login without a password. 
* [Style Pack #1](https://frosty.media/plugins/custom-login-style-pack-1?utm_source=wordpressorg&utm_medium=custom-login&utm_campaign=readme.txt "Custom Login Style Pack #1") - four pre-designed login styles. 
* [Style Pack #2](https://frosty.media/plugins/custom-login-style-pack-2?utm_source=wordpressorg&utm_medium=custom-login&utm_campaign=readme.txt "Custom Login Style Pack #2") - four pre-designed fun login styles. 
* [Style Pack #3](https://frosty.media/plugins/custom-login-style-pack-3?utm_source=wordpressorg&utm_medium=custom-login&utm_campaign=readme.txt "Custom Login Style Pack #3") - four pre-designed holiday login styles. 

**Extensions in development/extension ideas**

* Email Logins for usernames.
* 2-step Authentication.
* "Super User" only access for client sites.
* **Added in core as of version 3.0** Remove default WordPress login CSS.
* Submit button styles!
* **Added as of version 3.2** Custom Login pre made settings templates *AKA* [Style Packs](https://frosty.media/plugin/tag/style-pack/).

### More info ###

Activate the plugin and customize your WordPress login screen. It's as easy as modifying a few settings, there is no need to understand CSS at all. Custom Login even has a HTML, CSS &amp; jQuery textarea for more advanced customizations.

1. Works great for client site installs.
2. Read more about [Custom Login 3.1](https://frosty.media/2015/custom-login-v3-1-released/)
2. Read more about [Custom Login 2.0](http://wp.me/pzgsJ-HY)

**For those looking to showoff your login screen, check out the [Flickr group](http://flickr.com/groups/custom-login/)! Share you designs with the community!**

### links ###

* Premium Plugins: [https://frosty.media/plugins](https://frosty.media/plugins/ "Premium WordPress Plugins by Frosty")
* Austins Blog: [https:/austin.passy.co/](http://austin.passy.co/ "Austin Passy's blog")
* Austin on Twitter: @[TheFrosty](https:/twitter.com/TheFrosty "Austin TheFrosty' Passy on Twitter")
* Frosty Media on Twitter: @[Frosty_Media](https:/twitter.com/Frosty_Media "Frosty Media on Twitter")
* **Development welcomed on [GitHub](https://github.com/thefrosty/custom-login)**

### Hooks and Filters ###

Coming Soon.

## Installation ##

Follow the steps below to install the plugin.

1. Upload the `custom-login` directory to the /wp-content/plugins/ directory.
2. Activate the plugin through the 'plugins' menu in WordPress.
3. Go to Settings/custom-login to edit your settings.
4. Design away.
5. Activate the settings by checking "Enable" in the "General Settings" tab.

## Frequently Asked Questions ##

### What are extensions? ###
They are additional plugins that add/extend functionality to the Custom Login plugin. You can find all Custom Login extensions on [Frosty.Media](http://frosty.media).

### My new settings aren't showing up ###
This plugin caches all settings in a transient, try clicking the new 'Update stylesheet' button to delete and refresh the cache. *This will apply to versions < 3.0*.

### Is there a PRO version? ###
Well, yes and no. Since version 3.0 of Custom Login the [PRO](http://frosty.media/plugins/custom-login-pro/) version is a completely different plugin. Instead of settings to manage your login design there is a new post type where you can create unlimited "designs" and activate each one as needed. Since version 3.0 all Custom Login extensions no longer work with Custom Login Pro, but will be merged into it in the future.

### Why create this plugin? ###
I created this plugin to allow for custom login of any WordPress login screen. See working example on: [Frosty.Media/login](http://frosty.media/wp-login.php).

### Where can I upload and share my cool login screen? ###
Check out the [Flickr group](http://flickr.com/groups/custom-login/)! Upload and add it to our pool!

### I think i want to uninstall ###
Just deactivate it. Sad panda is sad.

## Screenshots ##

Custom Login showcase on the [Flickr group](http://flickr.com/groups/custom-login/).

###1. Custom Login v3 Design Settings part 1.
###
![Custom Login v3 Design Settings part 1.
](https://ps.w.org/custom-login/assets/screenshot-1.png)


###2. Custom Login v3 Design Settings part 2.
###
![Custom Login v3 Design Settings part 2.
](https://ps.w.org/custom-login/assets/screenshot-2.png)


###3. Custom Login v3 General Settings.
###
![Custom Login v3 General Settings.
](https://ps.w.org/custom-login/assets/screenshot-3.png)


###4. Custom Login Extensions Installer (an active license key is required).
###
![Custom Login Extensions Installer (an active license key is required).
](https://ps.w.org/custom-login/assets/screenshot-4.png)


## Changelog ##

### Version 3.2.9 (2019/05/07) ###
* Tested up to WordPress 5.2.
* Update deprecated login text filter in WordPress 5.2.
* Update animate.css to version 3.7.0.
* Update chosen.js to 1.8.7.
* Update jQuery Sticky to 1.0.4.
* Fix spelling error in admin JS on typeof check for ACE JS.

### Version 3.2.8 (12/11/17) ### 

* Update notifications URL to current correct location for admin settings page.

### Version 3.2.7 (11/13/17) ### 

* Fix duplicate CSS output in head bug.
* Fix empty link URL and title on wp login page when on multisite.

### Version 3.2.6 (11/10/17) ### 

* Check compatibility with WordPress 4.9.
* Update Settings API to fix `Undefined index: active` message.

### Version 3.2.5 (04/13/16) ###

* WordPress 4.5 compatible update (moves Custom Login css after WordPress' login style sheet).
* Fix issue where toggling the 'active' checkbox in the header doesn't activate or de-activate the plugin settings (updates via AJAX now).

### Version 3.2.4 (09/16/15) ###

* Fix PHP Fatal error.
** PHP Fatal error: Call to a member function get_permalink() on a non-object in /includes/admin/dashboard.php:114

### Version 3.2.2 (05/04/15) ###

* May the fourth be with you.
* Cleaned up dashboard JS errors.

### Version 3.2.2 (04/29/15) ###

* Update version number.
* Fix upgrade notice showing when not needed.
* Add class 'notice' and 'is-dismissible' to notice.
* Cleanup admin dashboard empty ob_get_clean() notice.

### Version 3.2.1 (04/20/15) ###

* Fix: XSS security flaw.
* Fix: Settings page not showing. (Fixes Issue: [#6](https://github.com/thefrosty/custom-login/pull/6) /ht @[DrewAPicture](https://github.com/DrewAPicture).

### Version 3.2 (02/09/15) ###

* Message: Celebrate 500,000 downloads. Visit the settings page or [this post](https://frosty.media/?p=26056) to get any extension for free! *Restrictions may apply.
* Notice: Introduce Custom Login [Style Pack #1](https://frosty.media/plugins/custom-login-style-pack-1)
* Fix: Possible headers_sent() error in some installations [forum](https://wordpress.org/support/topic/update-php-errors-dashboard-errors?replies=2).
* Fix: Setting update script might uncheck (turn off) the activate switch.
* Fix: CSS `#login form` box shadow not accepting opacity settings.
* Update: Default 'activate' setting to 'on'.
* Update: "Save Changes" submit button to "Save {Tab Title}".
* Update: Allow Custom (CSS/HTML/JS) textareas to expand up to 30 lines.
* Update: admin.css
* Update: admin.js
* Add: animate.css Licened under MIT.
* Add: Global 'active' toggle switch.

### Version 3.1 (01/20/15) ###

* Update: Disable auth cookie expiration function.
* Update: All prefixed 'cl_'  to 'custom_login_'.
* Update: Spelling error 'sanitize'.
* Update: login.css uses core stylesheet to avoid possible conflicts with checkboxes and browser support.
* Tweak: Speed imporovments.
* Add: CL_Common::is_settings_page().
* Add: Dashboard widget (off be default).

### Version 3.0.8 (01/14/15) ###

* Add: Auth timout setting when remember me is checked and not.
* Add: filter to wp_remote_get timeout. Use: `cl_wp_remote_get_timeout` to return (int) value, defaults to 15.
* Update: `auth_cookie_expiration` function.
* Update: Removed `post_password_expires` setting in favor of `auth_timeout` &amp; `auth_timeout_remember`.
* Fix: Possible white screen issue, for users who updated to 3.0.7 before a file was uploaded. (version bump).

### Version 3.0.7 (01/13/15) ###

* Update: ace.js to build `20.12.14`.
* Update: admin.css.
* Update: Extenstions HTML and settings page location.
* Update: Sanatize the `auth_cookie_expiration` setting with a positive integer.
* Tweak: Remove false positive files from malware scanners; ace editor php.js [forum](https://wordpress.org/support/topic/wordfence-alerta?).
* Tweak: Make sure `auth_cookie_expiration` is greater than 0.

### Version 3.0.6 (01/13/15) ###

* Bug: Misspelled variable returned on `auth_cookie_expiration` caused instant user logout.

### Version 3.0.5 (01/13/15) ###

* Add: Update uninstall.php with all options to delete.
* Add: Disable lost password reset function option.
* Update: Settings prefix with global definition.
* Update: Add missing auth expiration function for setting.
* Fix: Hide tracking notice globaly if admin notices are turned off.
* Tweak: Update the hide_wp_logo description since Custom Login removes the WP logo by default.
* Tweak: Better output of update notification on settings page.
* Tweak: Update input fields that are integers to a 'number' input type.
* Tweak: Update readme dates to 2015. :)

### Version 3.0.4 (01/12/15) ###

* Tweak: Add manual update link on settings page if new settings are empty and old settings exist.
* Fix: Make sure tracking is set to "on" before sending.

### Version 3.0.3 (01/12/15) ###

* Fix: Add missing "Remove WP Logo" setting.
* Fix: When "activate" isn't checked disable settings output.
* Fix: foreach error. When `get_editable_roles` fails to return an array. [forum](https://wordpress.org/support/topic/invalid-argument-supplied-for-foreach-error-line-in-wp-dashboard?replies=2#post-6427631)
* Fix: On Logo "insert" getting called on background image insert.
* Tweak: Update chosen JS to version 1.3.0.

### Version 3.0.2 (01/12/15) ###

* Fix: Logo background size width &amp; height settings not transfering over in upgrade process.
* Fix: Checking "Remove lost password text" removes the text instead of the other way around. [forum](https://wordpress.org/support/topic/lost-your-password-1) 

### Version 3.0.1 (01/11/15) ###

* New: Add force width option to force width on h1 logo wrapper.
* Bug: Change sanitization of all integer fields to 'int' vs 'absint' to allow empty or no value.
* Bug: Remove is_int function on Logo width and height style output.
* Tweak: On Logo upload and "insert" update the width and height input settings fields for logo with the image size.
* Tweak: Change CSS rule(s) from `#login h1 a` to `.login h1 a`.

### Version 3.0.0 (12/01/14) ###

_REQUIRES WordPress 3.9 or later_

* New: Complete rewrite.
* New: Settings page UI update, now matches your WordPress admin color scheme.
* New: Extensions installer moved to sparate settings page (hidden).
* New: Removed version [2.x changelog](http://plugins.svn.wordpress.org/custom-login/tags/2.4/readme.txt).

## Upgrade Notice ##

### 3.2 ###
Celebrate 500,000 downloads w/ a FREE extension! Update to version 3.2 for more info.

### 3.0.6 ###
Fixes unable to login to admin site.

### 3.0.5 ###
Complete rewrite of Custom Login, be sure to run the update script to keep your old settings.
